/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.keyboard;

import emulator.GUI.keyboard.VicKey;
import emulator.GUI.keyboard.VicKeyboardRow;
import emulator.hardware.io.peripherals.Button;
import java.util.HashMap;

public class VicKeyboard {
    private VicKeyboardRow[] key_rows;
    private HashMap<String, VicKey> key_map;

    public VicKeyboard(int rows) {
        this.key_rows = new VicKeyboardRow[rows];
        int i = 0;
        while (i < rows) {
            this.key_rows[i] = new VicKeyboardRow();
            ++i;
        }
        this.key_map = new HashMap();
    }

    public void addKey(int row, String id, VicKey key) {
        this.key_rows[row].addKey(key);
        if (id != null) {
            this.key_map.put(id, key);
        }
    }

    public int getRows() {
        return this.key_rows.length;
    }

    public int getCols(int row) {
        return this.key_rows[row].getCount();
    }

    public VicKey getKey(int row, int col) {
        return this.key_rows[row].getKey(col);
    }

    public Button getKey(String key_name) {
        return this.key_map.get(key_name);
    }
}

